/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.modules;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="DynamicLights_dropItems", name="Dynamic Lights on ItemEntities", version="1.0.1", dependencies="after:DynamicLights")
public class DroppedItemsLightSource {
    private Minecraft mcinstance;
    private long nextUpdate;
    private long updateInterval;
    private ArrayList trackedItems;
    private Thread thread;
    private boolean threadRunning;
    private HashMap itemsMap;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        String[] tokens;
        this.itemsMap = new HashMap();
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        Property itemsList = config.get("general", "LightItems", "50:15,89:12,348:10,91:15,327:15,76:10,331:10,314:14");
        itemsList.comment = "Item IDs that shine light when dropped in the World. Syntax: ItemID:LightValue, seperated by commas";
        Property updateI = config.get("general", "update Interval", 1000);
        updateI.comment = "Update Interval time for all Item entities in milliseconds. The lower the better and costlier.";
        this.updateInterval = updateI.getInt();
        for (String pair : tokens = itemsList.value.split(",")) {
            String[] values = pair.split(":");
            int id = Integer.valueOf(values[0]);
            int value = Integer.valueOf(values[1]);
            this.itemsMap.put(id, value);
        }
        config.save();
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        this.mcinstance = FMLClientHandler.instance().getClient();
        this.nextUpdate = System.currentTimeMillis();
        this.trackedItems = new ArrayList();
        this.threadRunning = false;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
    }

    private int getLightFromItemStack(um stack) {
        Integer i;
        if (stack != null && (i = (Integer)this.itemsMap.get(stack.c)) != null) {
            return i;
        }
        return 0;
    }

    private class EntityItemAdapter
    implements IDynamicLightSource {
        private px entity;
        private int lightLevel = 0;
        private boolean enabled = false;

        public EntityItemAdapter(px eI) {
            this.entity = eI;
        }

        public void onTick() {
            this.lightLevel = this.entity.af() ? 15 : DroppedItemsLightSource.this.getLightFromItemStack(this.entity.a);
            if (!this.enabled && this.lightLevel > 8) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 9) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource(this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource(this);
            this.enabled = false;
        }

        @Override
        public lq getAttachmentEntity() {
            return this.entity;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }

    private class EntityListChecker
    extends Thread {
        private final Object[] list;

        public EntityListChecker(List input) {
            this.list = input.toArray();
        }

        @Override
        public void run() {
            ArrayList<EntityItemAdapter> newList = new ArrayList<EntityItemAdapter>();
            for (Object o : this.list) {
                lq ent = (lq)o;
                if (!(ent instanceof px) || !ent.S()) continue;
                boolean found = false;
                Iterator iter = DroppedItemsLightSource.this.trackedItems.iterator();
                EntityItemAdapter adapter = null;
                while (iter.hasNext()) {
                    adapter = (EntityItemAdapter)iter.next();
                    if (!adapter.getAttachmentEntity().equals((Object)ent)) continue;
                    adapter.onTick();
                    newList.add(adapter);
                    found = true;
                    iter.remove();
                    break;
                }
                if (found) continue;
                adapter = new EntityItemAdapter((px)ent);
                adapter.onTick();
                newList.add(adapter);
            }
            DroppedItemsLightSource.this.trackedItems = newList;
            DroppedItemsLightSource.this.threadRunning = false;
        }
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet type, Object ... tickData) {
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (((DroppedItemsLightSource)DroppedItemsLightSource.this).mcinstance.e != null && System.currentTimeMillis() > DroppedItemsLightSource.this.nextUpdate && !DynamicLights.globalLightsOff()) {
                DroppedItemsLightSource.this.nextUpdate = System.currentTimeMillis() + DroppedItemsLightSource.this.updateInterval;
                if (!DroppedItemsLightSource.this.threadRunning) {
                    DroppedItemsLightSource.this.thread = new EntityListChecker(((DroppedItemsLightSource)DroppedItemsLightSource.this).mcinstance.e.e);
                    DroppedItemsLightSource.this.thread.setPriority(1);
                    DroppedItemsLightSource.this.thread.start();
                    DroppedItemsLightSource.this.threadRunning = true;
                }
            }
        }

        public EnumSet ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights_dropItems";
        }
    }
}

