/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.common;

import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class DLTransformer
implements IClassTransformer {
    private final String classNameWorldObfusc = "xv";
    private final String classNameBlockAccessObfusc = "yf";
    private final String computeBlockLightMethodNameO = "g";
    private final String classNameWorld = "net.minecraft.src.World";
    private final String classNameWorldJava = "net/minecraft/src/World";
    private final String blockAccessJava = "net/minecraft/src/IBlockAccess";
    private final String computeBlockLightMethodName = "computeBlockLightValue";

    public byte[] transform(String name, byte[] bytes) {
        if (name.equals("xv")) {
            return this.handleWorldTransform(bytes, true);
        }
        if (name.equals("net.minecraft.src.World")) {
            return this.handleWorldTransform(bytes, false);
        }
        return bytes;
    }

    private byte[] handleWorldTransform(byte[] bytes, boolean obfuscated) {
        System.out.println("**************** Dynamic Lights transform running on World *********************** ");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(obfuscated ? "g" : "computeBlockLightValue") || !m.desc.equals("(IIIIII)I")) continue;
            System.out.println("In target method! Patching!");
            AbstractInsnNode targetNode = null;
            ListIterator iter = m.instructions.iterator();
            while (iter.hasNext() && (targetNode = (AbstractInsnNode)iter.next()).getOpcode() != 54) {
                iter.remove();
            }
            if (targetNode == null) {
                System.err.println("Dynamic Lights transformer did not run into ISTORE node! ABANDON CLASS!");
                return bytes;
            }
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 5));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
            toInject.add((AbstractInsnNode)new VarInsnNode(21, 4));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "atomicstryker/dynamiclights/client/DynamicLights", "getLightValue", "(L" + (obfuscated ? "yf" : "net/minecraft/src/IBlockAccess") + ";IIII)I"));
            m.instructions.insertBefore(targetNode, toInject);
            System.out.println("Patching Complete!");
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

