/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.modules;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="DynamicLights_onFire", name="Dynamic Lights on burning", version="1.0.1", dependencies="after:DynamicLights")
public class BurningEntitiesLightSource {
    private Minecraft mcinstance;
    private long nextUpdate;
    private long updateInterval;
    private ArrayList trackedEntities;
    private Thread thread;
    private boolean threadRunning;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        Property updateI = config.get("general", "update Interval", 1000);
        updateI.comment = "Update Interval time for all burning EntityLiving, Arrows and Fireballs in milliseconds. The lower the better and costlier.";
        this.updateInterval = updateI.getInt();
        config.save();
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        this.mcinstance = FMLClientHandler.instance().getClient();
        this.nextUpdate = System.currentTimeMillis();
        this.trackedEntities = new ArrayList();
        this.threadRunning = false;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
    }

    private class EntityLightAdapter
    implements IDynamicLightSource {
        private lq entity;
        private int lightLevel = 0;
        private boolean enabled = false;

        public EntityLightAdapter(lq e) {
            this.entity = e;
        }

        public void onTick() {
            this.lightLevel = this.entity.af() ? 15 : 0;
            if (!this.enabled && this.lightLevel > 8) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 9) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource(this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource(this);
            this.enabled = false;
        }

        @Override
        public lq getAttachmentEntity() {
            return this.entity;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }

    private class EntityListChecker
    extends Thread {
        private final Object[] list;

        public EntityListChecker(List input) {
            this.list = input.toArray();
        }

        @Override
        public void run() {
            ArrayList<EntityLightAdapter> newList = new ArrayList<EntityLightAdapter>();
            for (Object o : this.list) {
                lq ent = (lq)o;
                if (!(ent instanceof md) && !(ent instanceof rb) && !(ent instanceof qz) || !ent.S() || !ent.af() || ent instanceof px || ent instanceof qx) continue;
                boolean found = false;
                Iterator iter = BurningEntitiesLightSource.this.trackedEntities.iterator();
                EntityLightAdapter adapter = null;
                while (iter.hasNext()) {
                    adapter = (EntityLightAdapter)iter.next();
                    if (!adapter.getAttachmentEntity().equals((Object)ent)) continue;
                    adapter.onTick();
                    newList.add(adapter);
                    found = true;
                    iter.remove();
                    break;
                }
                if (found) continue;
                adapter = new EntityLightAdapter((lq)((md)ent));
                adapter.onTick();
                newList.add(adapter);
            }
            for (EntityLightAdapter adapter : BurningEntitiesLightSource.this.trackedEntities) {
                adapter.onTick();
            }
            BurningEntitiesLightSource.this.trackedEntities = newList;
            BurningEntitiesLightSource.this.threadRunning = false;
        }
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet type, Object ... tickData) {
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (((BurningEntitiesLightSource)BurningEntitiesLightSource.this).mcinstance.e != null && System.currentTimeMillis() > BurningEntitiesLightSource.this.nextUpdate && !DynamicLights.globalLightsOff()) {
                BurningEntitiesLightSource.this.nextUpdate = System.currentTimeMillis() + BurningEntitiesLightSource.this.updateInterval;
                if (!BurningEntitiesLightSource.this.threadRunning) {
                    BurningEntitiesLightSource.this.thread = new EntityListChecker(((BurningEntitiesLightSource)BurningEntitiesLightSource.this).mcinstance.e.e);
                    BurningEntitiesLightSource.this.thread.setPriority(1);
                    BurningEntitiesLightSource.this.thread.start();
                    BurningEntitiesLightSource.this.threadRunning = true;
                }
            }
        }

        public EnumSet ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights_onFire";
        }
    }
}

