package atomicstryker.magicyarn.client;

import java.util.ArrayList;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;

public class AStarWorker implements Runnable
{
	public ArrayList closedNodes = new ArrayList();
	private AStarNode startNode;
	private AStarNode targetNode;
	private boolean searchMode;
	private boolean toLastPath;
	private Minecraft mc;

	private long startingTime;
	private int checkedCubes = 0;

	private final int maxCheckedCubes = 15000;
	private final int maxSize = 200;
	private final int maxSizeSq = maxSize*maxSize;

	private AStarNode[] openList = new AStarNode[maxSizeSq+1];
	private int addedItems = 1;

	@Override
	public void run()
	{
		ArrayList result = null;
		boolean force = false;
		if (!toLastPath || MagicYarn.lastPath == null)
		{
			result = getPath(startNode, targetNode, searchMode);
		}

		if (result == null && MagicYarn.path != null && MagicYarn.path.size() > 1)
		{
			startNode = (AStarNode) MagicYarn.path.get(0);
			resetSearch();
			result = getPath(startNode, targetNode, searchMode);
			if (result != null)
			{
				ArrayList concat = MagicYarn.path;
				concat.addAll(0, result);
				result = concat;
				force = true;
			}
		}
		
		if (result == null && MagicYarn.lastPath != null && MagicYarn.lastPath.size() > 1)
		{
			startNode = (AStarNode) MagicYarn.lastPath.get(0);
			resetSearch();
			result = getPath(startNode, targetNode, searchMode);
			if (result != null)
			{
				ArrayList concat = MagicYarn.lastPath;
				concat.addAll(0, result);
				result = concat;
				force = true;
			}
		}

		MagicYarn.inputPath(result, false, force);
	}

	public void setup(Minecraft minec, AStarNode start, AStarNode end, boolean mode, boolean lpath)
	{
		mc = minec;
		startNode = start;
		targetNode = end;
		searchMode = mode;
		toLastPath = lpath;
	}

	public void resetSearch()
	{
		closedNodes = new ArrayList();
		checkedCubes = 0;
		openList = new AStarNode[maxSizeSq+1];
		addedItems = 1;
	}

	public ArrayList getPath(int startx, int starty, int startz, int destx, int desty, int destz, boolean searchMode)
	{
		AStarNode starter = new AStarNode(startx, starty, startz, 0);
		AStarNode finish = new AStarNode(destx, desty, destz, -1);;

		return getPath(starter, finish, searchMode);
	}

	public ArrayList getPath(AStarNode start, AStarNode end, boolean searchMode)
	{
		openList[1] = start;
		startingTime = System.currentTimeMillis();

		targetNode = end;
		start.f_distanceToGoal = getDistanceBetweenNodes(start, targetNode);

		AStarNode current = start;

		while(!current.equals(end))
		{			
			deleteLowestValueInHeap();
			closedNodes.add(current);

			checkPossibleLadder(current);
			getNextCandidates(current, searchMode);

			if (addedItems == 0 || addedItems == maxSizeSq || Thread.interrupted() || checkedCubes >= maxCheckedCubes)
			{
				System.out.println("Aborting AStarWorker, checked Cubes: "+checkedCubes+"; interrupted: "+Thread.interrupted());
				return null;
			}

			current = openList[1];
			//System.out.println("Moving onto: ["+current.x+"|"+current.y+"|"+current.z+"], heuristic dist: "+current.distanceToGoal);
		}

		ArrayList foundpath = new ArrayList();
		foundpath.add(current);
		while (current != start)
		{
			foundpath.add(current.parent);
			current = current.parent;
		}

		System.out.println("AStarPath success, nodes: "+foundpath.size()+"; checked Cubes: "+checkedCubes);
		return foundpath;
	}

	private void addToBinaryHeap(AStarNode input)
	{
		addedItems++;
		openList[addedItems] = input;
		sortBinaryHeap();

		checkedCubes++;
	}

	private void sortBinaryHeap()
	{
		sortBinaryHeapFromValue(addedItems);
	}

	private void sortBinaryHeapFromValue(int m)
	{
		AStarNode swap;
		while (m > 1)
		{
			if (openList[m].f_distanceToGoal <= openList[m/2].f_distanceToGoal)
			{
				swap = openList[m/2];
				openList[m/2] = openList[m];
				openList[m] = swap;
				m = m/2;
			}
			else
			{
				break;
			}
		}
	}

	private void deleteLowestValueInHeap()
	{
		AStarNode swap;
		openList[1] = openList[addedItems];
		addedItems --;

		int v = 1;
		int u;
		for(;;)
		{
			u = v;
			if (2*u+1 <= addedItems)
			{
				if (openList[u].f_distanceToGoal >= openList[2*u].f_distanceToGoal)
				{
					v = 2*u;
				}
				if (openList[v].f_distanceToGoal >= openList[2*u+1].f_distanceToGoal)
				{
					v = 2*u+1;
				}
			}
			else if(2*u <= addedItems)
			{
				if (openList[u].f_distanceToGoal >= openList[2*u].f_distanceToGoal)
				{
					v = 2*u;
				}
			}

			if (u != v)
			{
				swap = openList[u];
				openList[u] = openList[v];
				openList[v] = swap;
			}
			else
			{
				break;
			}
		}
	}

	private void checkPossibleLadder(AStarNode parent)
	{
		int x = parent.x;
		int y = parent.y;
		int z = parent.z;

		if (isLadder(mc.theWorld.getBlockId(x, y, z)))
		{

			AStarNode ladder = null;
			if (isLadder(mc.theWorld.getBlockId(x, y+1, z)))
			{
				ladder = new AStarNode(x, y+1, z, parent.g_BlockDistToStart+1, parent);
				ladder.f_distanceToGoal = getDistanceBetweenNodes(ladder, targetNode);

				if (!tryToFindExistingHeapNode(parent, ladder))
				{
					addToBinaryHeap(ladder);
				}
			}
			if (isLadder(mc.theWorld.getBlockId(x, y-1, z)))
			{
				ladder = new AStarNode(x, y-1, z, parent.g_BlockDistToStart+1, parent);
				ladder.f_distanceToGoal = getDistanceBetweenNodes(ladder, targetNode);

				if (!tryToFindExistingHeapNode(parent, ladder))
				{
					addToBinaryHeap(ladder);
				}
			}
		}
	}
	
	private boolean isLadder(int id)
	{
		return (id == Block.ladder.blockID
			|| id == 242
			|| id == 243);
	}

	public void getNextCandidates(AStarNode parent, boolean searchMode)
	{
		int x = parent.x;
		int y = parent.y;
		int z = parent.z;
		int dist = parent.g_BlockDistToStart;

		int[][] c = searchMode ? candidates_allowdrops : candidates;

		AStarNode check;
		for (int i = 0; i < c.length; i++)
		{
			check = new AStarNode(x+c[i][0], y+c[i][1], z+c[i][2], dist+c[i][3], parent);
			check.f_distanceToGoal = getDistanceBetweenNodes(check, targetNode);

			if (closedNodes.contains(check))
			{
				((AStarNode) closedNodes.get(closedNodes.indexOf(check))).updateDistance(check.g_BlockDistToStart, parent);
			}
			else if (!tryToFindExistingHeapNode(parent, check))
			{
				if (isViable(check, c[i][1]))
				{
					addToBinaryHeap(check);
				}
			}
		}
	}

	private boolean tryToFindExistingHeapNode(AStarNode parent, AStarNode checkedOne)
	{
		for (int i = 1; i <= addedItems; i++)
		{
			if (openList[i].equals(checkedOne))
			{
				if (openList[i].updateDistance(checkedOne.g_BlockDistToStart, parent))
				{
					sortBinaryHeapFromValue(i);
					return true;
				}
				else
				{
					return false;
				}
			}
		}

		return false;
	}

	private boolean isViable(AStarNode target, int yoffset)
	{
		int x = target.x;
		int y = target.y;
		int z = target.z;
		int id = mc.theWorld.getBlockId(x, y, z);

		if (id == Block.ladder.blockID)
		{
			return true;
		}

		if (!isPassableBlock(x, y, z)
				|| !isPassableBlock(x, y+1, z)
				|| (isPassableBlock(x, y-1, z) && (id != Block.waterStill.blockID || id != Block.waterMoving.blockID)))
		{
			return false;
		}

		if (yoffset < 0) yoffset *= -1;
		int ycheckhigher = 1;
		while (ycheckhigher <= yoffset)
		{
			if (!isPassableBlock(x, y+yoffset, z))
			{
				return false;
			}
			ycheckhigher++;
		}

		return true;
	}

	private boolean isPassableBlock(int ix, int iy, int iz)
	{
		int id = mc.theWorld.getBlockId(ix, iy, iz);

		if (id != 0)
		{
			return !Block.blocksList[id].blockMaterial.isSolid();
		}

		return true;
	}

	private double getDistanceBetweenNodes(AStarNode a, AStarNode b)
	{
		return (Math.abs(a.x-b.x) + Math.abs(a.y - b.y) + Math.abs(a.z - b.z));
		//return Math.sqrt(Math.pow((a.x - b.x), 2) + Math.pow((a.y - b.y), 2) + Math.pow((a.z - b.z), 2));
	}

	private final static int candidates[][] =
		{
		{
			0, 0, -1, 1
		}, {
			0, 0, 1, 1
		}, {
			1, 0, 0, 1
		}, {
			-1, 0, 0, 1
		}, {
			1, 1, 0, 2
		}, {
			-1, 1, 0, 2
		}, {
			0, 1, 1, 2
		}, {
			0, 1, -1, 2
		}, {
			1, -1, 0, 1
		}, {
			-1, -1, 0, 1
		}, {
			0, -1, 1, 1
		}, {
			0, -1, -1, 1
		}
		};

	private final static int candidates_allowdrops[][] =
		{
		{
			0, 0, -1, 1
		}, {
			0, 0, 1, 1
		}, {
			1, 0, 0, 1
		}, {
			-1, 0, 0, 1
		}, {
			1, 1, 0, 2
		}, {
			-1, 1, 0, 2
		}, {
			0, 1, 1, 2
		}, {
			0, 1, -1, 2
		}, {
			1, -1, 0, 1
		}, {
			-1, -1, 0, 1
		}, {
			0, -1, 1, 1
		}, {
			0, -1, -1, 1
		}, {
			1, -2, 0, 1
		}, {
			-1, -2, 0, 1
		}, {
			0, -2, 1, 1
		}, {
			0, -2, -1, 1
		}
		};
}