/*
 * Decompiled with CFR 0.152.
 */
package com.github.parker8283.bif.asm;

import java.util.HashMap;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;

public class RemappingHelper {
    public static boolean obfuscated = false;
    private static HashMap<String, String> classNameToObfClassNameCache = new HashMap();
    private static HashMap<String, String> obfClassNameToClassNameCache = new HashMap();

    private static void cacheObfClassMapping(String obfClassName, String className) {
        obfClassNameToClassNameCache.put(obfClassName, className);
        classNameToObfClassNameCache.put(className, obfClassName);
    }

    public static String toDeobfClassName(String obfClassName) {
        if (obfuscated) {
            if (!obfClassNameToClassNameCache.containsKey(obfClassName)) {
                RemappingHelper.cacheObfClassMapping(obfClassName, FMLDeobfuscatingRemapper.INSTANCE.map(obfClassName.replace('.', '/')).replace('/', '.'));
            }
            return obfClassNameToClassNameCache.get(obfClassName);
        }
        return obfClassName;
    }

    public static String toObfClassName(String deobfClassName) {
        if (obfuscated) {
            if (!classNameToObfClassNameCache.containsKey(deobfClassName)) {
                RemappingHelper.cacheObfClassMapping(FMLDeobfuscatingRemapper.INSTANCE.unmap(deobfClassName.replace('.', '/')).replace('/', '.'), deobfClassName);
            }
            return classNameToObfClassNameCache.get(deobfClassName);
        }
        return deobfClassName;
    }

    public static String getInternalClassName(String className) {
        return RemappingHelper.toObfClassName(className).replace('.', '/');
    }

    public static String getDescriptor(String className) {
        return "L" + RemappingHelper.getInternalClassName(className) + ";";
    }
}

