/*
 * Decompiled with CFR 0.152.
 */
package com.github.parker8283.bif.asm;

import com.github.parker8283.bif.asm.RemappingClassWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMHelper {
    public static ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public static byte[] writeClassToBytes(ClassNode classNode) {
        RemappingClassWriter writer = new RemappingClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] writeClassToBytesNoRemap(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static MethodNode findMethodNodeOfClass(ClassNode classNode, String methodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || methodDesc != null && !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public static AbstractInsnNode getOrFindInstructionOfType(AbstractInsnNode firstInsnToCheck, int opcode, int times, boolean reverseDirection) {
        int timesFound = 0;
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (instruction.getOpcode() == opcode && times == ++timesFound) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }
}

