/*
 * Decompiled with CFR 0.152.
 */
package com.github.parker8283.bif.asm;

import com.github.parker8283.bif.BowInfinityFix;
import com.github.parker8283.bif.asm.RemappingHelper;
import org.objectweb.asm.ClassWriter;

public class RemappingClassWriter
extends ClassWriter {
    RemappingClassWriter(int flags) {
        super(flags);
    }

    protected String getCommonSuperClass(String type1, String type2) {
        if (!type1.startsWith("net/minecraft") || !type2.startsWith("net/minecraft")) {
            return super.getCommonSuperClass(type1, type2);
        }
        Class<?> a = null;
        Class<?> b = null;
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            a = Class.forName(RemappingHelper.toDeobfClassName(type1.replace('/', '.')), false, classLoader);
            b = Class.forName(RemappingHelper.toDeobfClassName(type2.replace('/', '.')), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            BowInfinityFix.log.error("This should never happen...", (Throwable)e);
        }
        if (a.isAssignableFrom(b)) {
            return type1;
        }
        if (b.isAssignableFrom(a)) {
            return type2;
        }
        if (a.isInterface() || b.isInterface()) {
            return "java/lang/Object";
        }
        while (!(a = a.getSuperclass()).isAssignableFrom(b)) {
        }
        return RemappingHelper.toObfClassName(a.getName()).replace('.', '/');
    }
}

