/*
 * Decompiled with CFR 0.152.
 */
package com.github.parker8283.bif;

import com.github.parker8283.bif.BowInfinityFix;
import com.github.parker8283.bif.asm.ASMHelper;
import com.github.parker8283.bif.asm.RemappingHelper;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Transformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.item.ItemBow")) {
            BowInfinityFix.log.info("Found ItemBow class");
            boolean isObfuscated = !name.equals(transformedName);
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "a" : "onItemRightClick", "(" + RemappingHelper.getDescriptor("net.minecraft.item.ItemStack") + RemappingHelper.getDescriptor("net.minecraft.world.World") + RemappingHelper.getDescriptor("net.minecraft.entity.player.EntityPlayer") + ")" + RemappingHelper.getDescriptor("net.minecraft.item.ItemStack"));
            if (methodNode == null) {
                throw new RuntimeException("Could not find onItemRightClick method in ItemBow class");
            }
            BowInfinityFix.log.info("Found onItemRightClick method");
            this.injectInfinityCheck(methodNode, isObfuscated);
            return ASMHelper.writeClassToBytes(classNode);
        }
        return basicClass;
    }

    private void injectInfinityCheck(MethodNode method, boolean isObfuscated) {
        AbstractInsnNode targetNode = ASMHelper.getOrFindInstructionOfType(method.instructions.getFirst(), 154, 1, false);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, RemappingHelper.getInternalClassName("net.minecraft.enchantment.Enchantment"), isObfuscated ? "y" : "infinity", RemappingHelper.getDescriptor("net.minecraft.enchantment.Enchantment")));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, RemappingHelper.getInternalClassName("net.minecraft.enchantment.Enchantment"), isObfuscated ? "B" : "effectId", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, RemappingHelper.getInternalClassName("net.minecraft.enchantment.EnchantmentHelper"), isObfuscated ? "a" : "getEnchantmentLevel", "(I" + RemappingHelper.getDescriptor("net.minecraft.item.ItemStack") + ")I", false));
        toInject.add((AbstractInsnNode)new JumpInsnNode(157, ((JumpInsnNode)targetNode).label));
        method.instructions.insertBefore(targetNode.getNext(), toInject);
        BowInfinityFix.log.info("Fix injected! Enjoy!");
    }
}

