/*
 * Decompiled with CFR 0.152.
 */
package org.shadowmods.arrowcam;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import org.shadowmods.arrowcam.ArrowCam;
import org.shadowmods.arrowcam.MathHelper;

public class EntityCamera
extends EntityLiving {
    private static EntityCamera instance;
    private Entity target;
    private boolean enabled;
    private boolean invert;
    private boolean isReturning;
    private int maxLife;
    private int despawnDelay;
    private boolean hideGUI;
    private float fovSetting;
    private int thirdPersonView;
    private static final int positionSmoother = 5;
    private static final int rotationSmoother = 5;

    private EntityCamera() {
        super(null);
        this.func_70105_a(0.0f, 0.0f);
    }

    public static EntityCamera getInstance() {
        if (instance == null) {
            instance = new EntityCamera();
        }
        return instance;
    }

    public void startCam(Entity target) {
        this.startCam(target, false);
    }

    public void startCam(Entity target, boolean invert) {
        this.startCam(target, invert, ArrowCam.camMaxLife);
    }

    public void startCam(Entity target, boolean invert, int maxLife) {
        this.startCam(target, invert, maxLife, 20);
    }

    public void startCam(Entity target, boolean invert, int maxLife, int despawnDelay) {
        Minecraft mc = Minecraft.func_71410_x();
        this.stopCam();
        this.hideGUI = mc.field_71474_y.field_74319_N;
        this.fovSetting = mc.field_71474_y.field_74334_X;
        this.thirdPersonView = mc.field_71474_y.field_74320_O;
        mc.field_71474_y.field_74319_N = true;
        mc.field_71474_y.field_74320_O = 1;
        mc.func_175607_a((Entity)this);
        this.enabled = true;
        this.isReturning = false;
        this.target = target;
        this.invert = invert;
        this.maxLife = maxLife;
        this.despawnDelay = despawnDelay;
        this.field_70128_L = false;
        this.field_70170_p = target.field_70170_p;
        this.field_70170_p.func_72838_d((Entity)this);
        this.func_70107_b(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
        this.func_70101_b(mc.field_71439_g.field_70177_z, mc.field_71439_g.field_70125_A);
        this.doCameraMove();
    }

    public void stopCam() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.field_70170_p != null) {
            this.field_70170_p.func_72900_e((Entity)this);
        }
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.isReturning = false;
        mc.field_71474_y.field_74319_N = this.hideGUI;
        mc.field_71474_y.field_74334_X = this.fovSetting;
        mc.field_71474_y.field_74320_O = this.thirdPersonView;
        mc.func_175607_a((Entity)mc.field_71439_g);
    }

    private void doCameraMove() {
        double x = this.field_70165_t + (this.target.field_70165_t - this.field_70165_t) / 5.0;
        double y = this.field_70163_u + (this.target.field_70163_u - this.field_70163_u) / 5.0;
        double z = this.field_70161_v + (this.target.field_70161_v - this.field_70161_v) / 5.0;
        float yaw = MathHelper.getShortAngle(this.field_70177_z, this.target.field_70177_z);
        float pitch = MathHelper.getShortAngle(this.field_70125_A, this.target.field_70125_A);
        if (this.invert) {
            yaw = -(this.field_70177_z + yaw);
            pitch = -(this.field_70125_A + pitch);
        } else {
            yaw /= 5.0f;
            pitch /= 5.0f;
            yaw += this.field_70177_z;
            pitch += this.field_70125_A;
        }
        yaw = MathHelper.normalize(yaw);
        pitch = MathHelper.normalize(pitch);
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    private void setIsReturning() {
        double oldPosX = this.field_70165_t;
        double oldPosY = this.field_70163_u;
        double oldPosZ = this.field_70161_v;
        float oldYaw = this.field_70177_z;
        float oldPitch = this.field_70125_A;
        this.startCam((Entity)Minecraft.func_71410_x().field_71439_g, false, 20);
        this.func_70107_b(oldPosX, oldPosY, oldPosZ);
        this.func_70101_b(oldYaw, oldPitch);
        this.isReturning = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70030_z() {
        block11: {
            super.func_70030_z();
            if (!this.enabled) {
                return;
            }
            if (this.target.field_70128_L && this.target instanceof EntityArrow) {
                this.target.field_70128_L = false;
            }
            if (!ArrowCam.isActive && !this.isReturning) {
                if (ArrowCam.animReturn && this.target != Minecraft.func_71410_x().field_71439_g) {
                    this.setIsReturning();
                    break block11;
                } else {
                    this.stopCam();
                    return;
                }
            }
            if (this.maxLife < 0 || this.despawnDelay < 0) {
                if (ArrowCam.animReturn && this.target != Minecraft.func_71410_x().field_71439_g) {
                    this.setIsReturning();
                    break block11;
                } else {
                    this.stopCam();
                    return;
                }
            }
            if (this.target.field_70128_L) {
                --this.despawnDelay;
                return;
            }
            --this.maxLife;
        }
        if (this.isReturning) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (Math.abs(this.field_70165_t - player.field_70165_t) < 1.0 && Math.abs(this.field_70163_u - player.field_70163_u) < 1.0 && Math.abs(this.field_70161_v - player.field_70161_v) < 1.0) {
                this.isReturning = false;
                this.stopCam();
            }
        }
        this.doCameraMove();
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        ArrowCam.isActive = ArrowCam.keyStartCam.func_151470_d();
    }

    public boolean func_180431_b(DamageSource damageSource) {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
    }
}

